package gov.va.med.mhv.getcare.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;

public interface HealthInsuranceService {

	@POST
	@Path("/healthInsurance")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public ResponseUtil save(HealthInsuranceDTO healthInsuranceDTO) throws MHVException;

	@DELETE
	@Path("/deleteInsurance/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public ResponseUtil delete(@PathParam("id") Long id) throws MHVException;

	@GET
	@Path("/healthInsuranceById/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public HealthInsuranceDTO findByPrimaryKey(@PathParam("id") Long id) throws MHVException;

	@GET
	@Path("/healthInsurance/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<HealthInsuranceDTO> findInsurancesForUser(@PathParam("userid") Long userid) throws MHVException;

	@GET
	@Path("/dashboardHealthInsurance/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<HealthInsuranceDTO> findDashBoardInsurancesForUser(@PathParam("userid") Long userid)
			throws MHVException;
}